<?php
namespace Home\Controller;

use Redis;

use SignedCookie;
use Think\Controller;
use Zhida\OAuthHelperV3;
use Think\Log;

class IndexController extends Controller
{
    private $auth_type = OAuthHelperV3::SCOPE_BASE;
//    private $auth_type = OAuthHelperV3::SCOPE_USERINFO;
    private $cookie_uid_key = 'mtime-laopao-v1';
    private $debug = 1;
    private $today;
    use ControllerTrait;

    public function _initialize()
    {

        $this->debug = $this->debug && session('X-DEBUG') ? true : false;
        $pub_mode = C('PUBLISH_MODE');
        if (ACTION_NAME != 'test_magic' && ACTION_NAME != 'debug_close' && ACTION_NAME != 'debug_open'
            && $pub_mode != 'production'
            && cookie('X-PUB_MODE') != 'development'
        ) {
            header("Content-type: text/html; charset=utf-8");
            echo '活动尚未开始，敬请期待';
            exit(0);
        }
        $this->today = date('Ymd');
    }
//$user = $this->get_user_info_from_cookie();
//if (!$user) {
//$this->ajaxReturn(array(
//'errcode' => 1,
//'errmsg' => '用户信息错误',
//));
//return;
//}
    public function index()
    {
        $openSate=M('Sate')->where(array(
            'id'=>1
        ))->getField('sate');
        if($openSate==0){
            die("活动未开始！");
        }
        $user = $this->get_user_info_from_cookie();
        if (!$user) {
            $this->request_auth($this->get_url());
            return;
        }
        $prize_type = M('Prize')->where(array('user_id' => $user['id']))->find();

        if ($prize_type) {
            $type = 1;
        } else {
            if($user['play_num']==0){
                $type = 2;

            }else{

                $type = 0;
            }

        }
        $this->assign('type', $type);
        $this->display();
    }

    public function get_random_prize($user,$channel)
    {
        $v = rand(0, 1000000) / 1000000;
        $today_ratio = 1;
        if ($v > $today_ratio) {
            return false;
        }
        $now = time();

        $req_type = array();
        $type_list = array(1);
        foreach ($type_list as $type) {
            $c = M('prize')->where(array(
                'type' => $type,
                'is_get' => 1,
            ))->count();

            if ($type == 1) {
                if ($c >= 10) {
                    continue;
                }
            }
            $req_type[] = $type;
        }
        if (empty($req_type)) {
            return false;
        }
        $prize = M('Prize')->where(array(
            'is_get' => 0,
            'user_id' => 0,
            'type' => array('in', $req_type),
        ))->order('rand()')->limit(1)->find();
        if (!$prize) {
            return false;
        }
        $result = M('Prize')->where(array(
            'id' => $prize['id'],
            'is_get' => 0,
            'user_id' => 0,
        ))->save(array(
            'is_get' => 1,
            'user_id' => $user['id'],
            'take_time' => $now,
            'last_ip' => $this->getIP(),
            'channel' => $channel
        ));
        if ($result > 0) {
            return $prize;
        }
        return false;
    }

    public function tryPrize()
    {
        $user = $this->get_user_info_from_cookie();
        if (!$user) {
            $this->ajaxReturn(array(
                'errcode' => 1,
                'errmsg' => '用户信息错误',
            ));
            return;
        }
        if($user['play_num']==0){
            $this->ajaxReturn(array(
                'errcode' => 2,
                'errmsg' => null
            ));
            return;
        }
        $type_list = array('6JTjh8cPcQ6Rh4Zs','wrwSQkP7aBSTSz6Q','DQxcxExXHmrrJhpW','Mx7cz5zBhJ4XTWWw','BnFaQJ23ddQ6CcfG','4fzkwfPHZZZmnQJx','NCnWMkSN5jSBErP6','Ce238NWT3GAkmXNB','7QnGFjs7JDxWe2xQ','5Qtk2aKHsG42PbRz');
        $channel_urt=$_POST['channel'];
        $c_z=in_array($channel_urt,$type_list);
        if(!$c_z){
            $this->ajaxReturn(array(
                'errcode' => 1,
                'errmsg' => null,
                'data' => array(
                    'prize' => 0
                )
            ));
            return;
        }
        $channel=M('Prize')->where(array(
            'channel'=>$channel_urt
        ))->find();
        M('User')->where(array(
            'id' => $user['id']
        ))->setDec('play_num');
        if($channel){
            $this->ajaxReturn(array(
                'errcode' => 1,
                'errmsg' => null,
                'data' => array(
                    'prize' => 0
                )
            ));
            return;
        }
          $prize = M('Prize')->where(array(
              'user_id' => $user['id']
          ))->find();
        if ($prize) {
            $this->ajaxReturn(array(
                'errcode' => 0,
                'errmsg' => null,
                'data' => array(
                    'prize' => 1,
                    'type' => 1,
                )
            ));
            return;
        }
        $prize = $this->get_random_prize($user,$channel_urt);
        if ($prize) {
            $this->ajaxReturn(array(
                'errcode' => 0,
                'errmsg' => null,
                'data' => array(
                    'prize' => 1,
                )
            ));
        } else {
            $this->ajaxReturn(array(
                'errcode' => 1,
                'errmsg' => null,
                'data' => array(
                    'prize' => 0,
                    'channel' => $_GET['channel']
                )
            ));

        }


    }

    public function ceshi()
    {
        for ($i = 0; $i < 10; $i++) {

            M('Prize')->add(array(
                'prize_url' => 'https://www.baidu.com/',
                'type' => 1
            ));

        }

    }

}
