<?php
namespace Home\Controller;

use Redis;

use SignedCookie;
use Think\Controller;
use Zhida\OAuthHelperV3;
use Think\Log;

class IndexController extends Controller
{
//    private $auth_type = OAuthHelperV3::SCOPE_BASE;
    private $auth_type = OAuthHelperV3::SCOPE_USERINFO;
    private $cookie_uid_key = 'mtime-laopao-v1';
    private $debug = 1;
    private $today;
    use ControllerTrait;

    public function _initialize()
    {

        $this->debug = $this->debug && session('X-DEBUG') ? true : false;
        $pub_mode = C('PUBLISH_MODE');
        if (ACTION_NAME != 'test_magic' && ACTION_NAME != 'debug_close' && ACTION_NAME != 'debug_open'
            && $pub_mode != 'production'
            && cookie('X-PUB_MODE') != 'development'
        ) {
            header("Content-type: text/html; charset=utf-8");
            echo '活动尚未开始，敬请期待';
            exit(0);
        }
        $this->today = date('Ymd');
    }
//$user = $this->get_user_info_from_cookie();
//if (!$user) {
//$this->ajaxReturn(array(
//'errcode' => 1,
//'errmsg' => '用户信息错误',
//));
//return;
//}
    public function index()
    {
        $user = $this->get_user_info_from_cookie();
        if (!$user) {
            $this->request_auth($this->get_url());
            return;
        }
        $prize_type = M('Prize')->where(array('user_id' => $user['id']))->find();
        if ($prize_type) {

            $type = 1;
        } else {

            $type = 0;
        }
        $this->assign('type', $type);
        $this->display();
    }
    public function get_random_prize($user)
    {
        $v = rand(0, 1000000) / 1000000;
            $today_ratio = 1;
        if ($v > $today_ratio) {
            return false;
        }
        $now = time();

        $to = strtotime(date('Y-m-d', $now + 86400));
        $req_type = array();
        $type_list = array(1);
        foreach ($type_list as $type) {
            $c = M('prize')->where(array(
                'type' => $type,
                'is_get' => 1,
            ))->count();

            if ($type == 1) {
                if ($c >= 10) {
                    continue;
                }
            }

            $req_type[] = $type;
        }
        if (empty($req_type)) {
            return false;
        }
        $prize = M('Prize')->where(array(
            'is_get' => 0,
            'user_id' => 0,
            'type' => array('in', $req_type),
        ))->order('rand()')->limit(1)->find();
        if (!$prize) {
            return false;
        }
        $result = M('Prize')->where(array(
            'id' => $prize['id'],
            'is_get' => 0,
            'user_id' => 0,
        ))->save(array(
            'is_get' => 1,
            'user_id' => $user['id'],
            'take_time' => $now,
            'last_ip' => $this->getIP(),
            'channel'=>$_GET['channel']
        ));
        if ($result > 0) {
            return $prize;
        }
        return false;
    }

    public function tryPrize()
    {
        $user = $this->get_user_info_from_cookie();
        if (!$user) {
            $this->ajaxReturn(array(
                'errcode' => 1,
                'errmsg' => '用户信息错误',
            ));
            return;
        }
        $type = $_GET['channel'];

        $prize = M('Prize')->where(array(
            'user_id' => $user['id']
        ))->find();
        if($prize['channel']==$type){
            $this->ajaxReturn(array(
                'errcode' => 1,
                'errmsg' => null,
                'data' => array(
                    'prize' => 0,
                )
            ));
            return;
        }
        if ($prize) {
            $this->ajaxReturn(array(
                'errcode' => 0,
                'errmsg' => null,
                'data' => array(
                    'prize' => 1,
                    'type' => 1,
                )
            ));
            return;
        }
        $now = time();
        $from = strtotime(date('Y-m-d-h:i', $now));
        $prize = $this->get_random_prize($user);
        if ($prize) {
            $this->ajaxReturn(array(
                'errcode' => 0,
                'errmsg' => null,
                'data' => array(
                    'prize' => 1,
                )
            ));
        } else {
            $this->ajaxReturn(array(
                'errcode' => 1,
                'errmsg' => null,
                'data' => array(
                    'prize' => 0,
                    'time'=>$from,
                    'data'=>date('Y-m-d-h:i', $now)
                )
            ));

        }
    }

    public function ceshi()
    {
        for ($i = 0; $i < 40; $i++) {

            M('Prize')->add(array(
                'prize_url' => 'https://www.baidu.com/',
                'type' => 1
            ));

        }

    }

}
