function preloadimages(obj, complete_cb, progress_cb) {
    var loaded = 0;
    var toload = 0;
    var images = obj instanceof Array ? [] : {};
    toload = obj.length;
    for (var i = 0; i < obj.length; i++) {
        images[i] = new Image();
        images[i].src = obj[i];
        // console.log(obj[i]);
        images[i].onload = load;
        images[i].setAttribute('crossOrigin', 'anonymous');
        images[i].onerror = load;
        images[i].onabort = load;
    }
    if (obj.length == 0) {
        complete_cb(images);
    }

    function load() {
        ++loaded;
        if (progress_cb) {
            progress_cb(loaded / toload);
        }
        if (loaded >= toload) {
            complete_cb(images);
        }
    }
}

var picUrl = window.base_resource_url + '/images/';

var preloadImageList = [
    // picUrl + 'share.png',
    ];
    if ($('div').length > 0) {
        $.each($('div'), function (index, val) {
            var img = $(val).css('background-image').replace(/^url\((['"]?)(.*)\1\)$/, '$2');
            img = $.trim(img);
            if (img && img.match(/[^/]+(jpg|png|gif)$/)) {
                preloadImageList.push(img);
            }
        });
    }


preloadimages(preloadImageList, function () {

}, function (progress) {

});

// $('input[name=customize]').attr('placeholder','输入自定义文字（仅限四个字）').attr('maxlength','4');
$('input[name=tel]').attr('type','tel');
$('input[name=tel]').attr('maxlength',11);

$('.page1').show();

$(document).ready(function () {
    $("input").on("blur",function(){
        window.scroll(0,0);//失焦后强制让页面归位
    });
    //显示活动规则
    $('.btn-rule').on('click',showRule);
    //隐藏活动规则
    $('.page1 .btn-close').on('click',hideRule);
    //首页跳转到城市选择页
    $('.page1 .btn-start').on('click',showMap);
    //哈尔滨
    $('.map-page .heb').on('click',handleHebClick);
    $('.map-page .bj').on('click',{types: 1},handleBjClick);
    //奖品页返回城市选择页
    $('.prize-page .btn-backtomap').on('click',backToMap);
});

function backToMap () {
    $('.prize-page').hide();
    $('.map-page').show();
}

function handleHebClick () {
    //播放哈尔滨视频

    //播放结束后跳转抽奖

    //奖品请求后跳转页面
    $('.map-page').hide();
    $('.prize-page').show();
    showPrize(1);
}

function handleBjClick (types) {
    //播放哈尔滨视频

    //播放结束后跳转抽奖

    //奖品请求后跳转页面
    // $('.map-page').hide();
    // $('.prize-page').show();
    // showPrize(1);
    console.log(types);
}

function showMap () {
    $('.page1').hide();
    $('.map-page').show();
}

function hideRule () {
    $('.dialog-rule').fadeOut(300);
}

function showRule () {
    $('.dialog-rule').fadeIn(300);
}

function showPrize (types) {
    //暂定奖品1视频月卡
    $('.prize-page .prize').hide();
    if (types > 0) {
        $('.prize-page .prize' + types).show();
        $('.prize-page .tel-block').show();
    } else {
        $('.prize-page .tel-block').hide();
        $('.prize-page .no-prize').show();
    }
}

function getTranslateDistance(cardinal = 0) {
    var wrapInnerTransform = $('.wrap-inner').css('transform');
    var wrapInnertop = parseFloat($('.wrap-inner').css('top'));
    wrapInnerTransform = wrapInnerTransform.match(/^matrix\(1,\s0,\s0,\s1,\s0,\s\-?(\d+)/);
    wrapInnerTransform = parseFloat(wrapInnerTransform[1]);
    var wrapInnerjl = Math.abs(wrapInnertop - wrapInnerTransform);
    return wrapInnerjl + cardinal + 'px';
}

//获取随机数方法
//min 最小值
//max 最大值
function RandomNumBoth(Min,Max){
    var Range = Max - Min;
    var Rand = Math.random();
    var num = Min + Math.round(Rand * Range); //四舍五入
    return num;
}