<?php
namespace Home\Controller;

use Think\Controller;
use SignedCookie;
use Zhida\OAuthHelperV3;
use Think\Upload\Driver\Qiniu\QiniuStorage;

use Think\Log;

class IndexController extends Controller
{
    private $auth_type = OAuthHelperV3::SCOPE_USERINFO;
    private $cookie_uid_key = 'skp-rotor-v1';
    private $debug = 1;
    private $today;
    use ControllerTrait;
    
    public function index()
    {
        session_start();
        $_SESSION['joinTime'] = time();
        $user = $this->get_user_info_from_cookie();
        // 如果没有获取到用户信息，引导用户授权
        if (!$user) {
            $this->request_auth($this->get_url());
            return;
        }
        M('join_num')->where('id=1')->setInc('num');
        $joinNum = M('join_num')->where('id=1')->find();
        $this->assign('pt',$user['prize_type']);
        $this->assign('join_num',$joinNum['num']);
        $this->display();
    }

    public function get_random_prize($user)
    {
        $v = rand(0, 1000000) / 1000000;
        $today_ratio = 0;
        if ($v > $today_ratio) {
            return false;
        }
        $now = time();
        $type = 1;
        $c = M('prize')->where(array(
            'type' => $type,
        ))->count();
        if ($c >= 20) {
            return false;
        }

        $prize = M('Prize')->where(array(
            'is_get' => 0,
            'uid' => 0
        ))->order('rand()')->limit(1)->find();
        if (!$prize) {
            return false;
        }
        $result = M('Prize')->where(array(
            'id' => $prize['id'],
            'is_get' => 0,
            'uid' => 0,
        ))->save(array(
            'is_get' => 1,
            'uid' => $user['id'],
            'take_time' => $now
        ));
        if ($result > 0) {
            
            return $prize;
        }
        return false;
    }
    public function tryPrize()
    {
        $user = $this->get_user_info_from_cookie();
        if (!$user) {
            $this->ajaxReturn(array(
                'status' => 404,
                'msg' => '用户信息错误',
                'step' => 0
            ));
            return;
        }
        var_dump($user['prize_type']);die();
        if($user['prize_type'] !== '0') {
            $this->ajaxReturn(array(
                'status' => -1,
                'msg' => '很遗憾,没有中奖',
                'step' => 3,
                'times' => $playTimes,
            ));
            return;
        }
        $prize = $this->get_random_prize($user);
        if ($prize) {
            M('user')->where(array(
                'id' => $user['id']
            ))->save(array(
                'prize_type' => 1
            ));
            $this->ajaxReturn(array(
                'status' => 1,
                'msg' => '恭喜您中奖了!',
                'step' => 4
            ));
        } else {
            M('user')->where(array(
                'id' => $user['id']
            ))->save(array(
                'prize_type' => 2
            ));
            $this->ajaxReturn(array(
                'status' => 2,
                'msg' => '恭喜您中奖了!',
                'step' => 5,
            ));
        }
    }

    public function ceshi()
    {
        for ($i = 0; $i < 20; $i++) {
            M('Prize')->add(array(
                'type' => '1',
                'prize_name' => '樱桃小丸子系列CP礼盒',
            ));
        }
    }
    public function cookie()
    {
        SignedCookie::set_cookie($this->cookie_uid_key, 'oVsrlt0zUWMLvMx2-KPGVmY2I-Xc', C('cookie_sign'), 86400 * 60);
    }
}