function preloadimages(obj, complete_cb, progress_cb) {
    var loaded = 0;
    var toload = 0;
    var images = obj instanceof Array ? [] : {};
    toload = obj.length;
    for (var i = 0; i < obj.length; i++) {
        images[i] = new Image();
        images[i].src = obj[i];
        // console.log(obj[i]);
        images[i].onload = load;
        images[i].setAttribute('crossOrigin', 'anonymous');
        images[i].onerror = load;
        images[i].onabort = load;
    }
    if (obj.length == 0) {
        complete_cb(images);
    }

    function load() {
        ++loaded;
        if (progress_cb) {
            progress_cb(loaded / toload);
        }
        if (loaded >= toload) {
            complete_cb(images);
        }
    }
}

var picUrl = window.base_resource_url + '/image2/';

var preloadImageList = [
    // picUrl + 'share.png',
];
if ($('div').length > 0) {
    $.each($('div'), function (index, val) {
        var img = $(val).css('background-image').replace(/^url\((['"]?)(.*)\1\)$/, '$2');
        img = $.trim(img);
        if (img && img.match(/[^/]+(jpg|png|gif)$/)) {
            preloadImageList.push(img);
        }
    });
}


preloadimages(preloadImageList, function () {
    $('.loading-page').hide();
    $('.home-page').show();
}, function (progress) {
    $('.loading-page .progress').css('width', (16.6 / 100) * (progress * 100) + 'rem');
});

//当前用户题目索引
let nowQuestionIndex = 1;
//当前题目用户选择答案
let nowAnswer = '';
//答案数组
let answerArr = [];

//海报canvas
let posterCanvas;
let posterCtx;


$(document).ready(function () {
    $("input").on("blur", function () {
        window.scroll(0, 0); //失焦后强制让页面归位
    });
    $('.index-block').css('top', getTranslateDistance(20));
    //显示答题页面
    $('.home-page .btn-next').on('click', showQuestion);
    //答案选中
    $('.answer').on('click', chooseAnswer);
    //下一题
    $('.btn-nextquestion').on('click', nextQuestion);
});

function nextQuestion() {
    if (nowAnswer !== '') {
        answerArr[nowQuestionIndex - 1] = nowAnswer;
        nowAnswer = '';
        $('.question' + nowQuestionIndex + '-block').addClass('fadeoutleft');
        nowQuestionIndex++;
        setTimeout(function () {
            $('.question' + nowQuestionIndex + '-block').show();
        }, 900);
    } else {
        $('#notification_area').remove();
        my_notify('请选择答案');
        return false;
    }

}

function chooseAnswer(e) {
    let node = $(e.target);
    $('.answer-active').hide();
    if (node.attr('class').indexOf('active') != -1) {
        nowAnswer = '';
    } else {
        nowAnswer = $('.question' + nowQuestionIndex + '-block .answer').index(node);
        node.find('div[class$=-active]').show();
    }

}

function showQuestion() {
    initQuestion();
    $('.home-page').hide();
    $('.question-page').show();
}

function initQuestion() {
    $('.answer-active').hide();
    $('.question-block').hide();
    $('.question1-block').show();
    $('.btn-submit').hide();
    $('.btn-nextquestion').show();
    nowQuestionIndex = 1;
    answerArr = [];
    nowAnswer = '';
}


function initCanvas(target, id, canvasWidth, canvasHeight, useRem = false) {
    if (useRem) {
        canvasWidth = pxToRem(canvasWidth);
        canvasHeight = pxToRem(canvasHeight);
    }
    $(target).append($('<canvas id="' + id + '" width="' + canvasWidth + '" height="' + canvasHeight + '"></canvas>'));
    canvas = $('#' + id)[0];
    ctx = canvas.getContext("2d");
    ctx.scale(2, 2);
    canvas.width = canvasWidth;
    canvas.height = canvasHeight;
    return [canvas, ctx];
}

function getTranslateDistance(cardinal = 0) {
    var wrapInnerTransform = $('.wrap-inner').css('transform');
    var wrapInnertop = parseFloat($('.wrap-inner').css('top'));
    wrapInnerTransform = wrapInnerTransform.match(/^matrix\(1,\s0,\s0,\s1,\s0,\s\-?(\d+)/);
    wrapInnerTransform = parseFloat(wrapInnerTransform[1]);
    var wrapInnerjl = Math.abs(wrapInnertop - wrapInnerTransform);
    return wrapInnerjl + cardinal + 'px';
}

//获取随机数方法
//min 最小值
//max 最大值
function RandomNumBoth(Min, Max) {
    var Range = Max - Min;
    var Rand = Math.random();
    var num = Min + Math.round(Rand * Range); //四舍五入
    return num;
}


function pxToRem(px) {
    return (px / 20) * fontSize;
}