$.preload_resource = function () {
    var $loading_text = null;
    var resource_list = null;
    var on_complete = null;
    var total = 0;
    var loaded_success = 0;
    var loaded_failed = 0;
    var loaded_count = 0;
    var check_time = 60;
    var init = function (_resource_list, _on_complete, _$loading_text) {
        resource_list = _resource_list;
        if (_on_complete !== undefined) {
            on_complete = _on_complete;
        }
        if (_$loading_text !== undefined) {
            $loading_text = _$loading_text;
        }
        total = resource_list.length;
    };

    var load = function () {
        var i = 0;
        for (; i < resource_list.length; i++) {
            if ($.isArray(resource_list[i])) {
                do_load_one(resource_list[i][0], resource_list[i][1]);
            } else {
                do_load_one('image', resource_list[i]);
            }
        }
    };
    var do_load_one = function (type, url) {
        if (type == 'image') {
            var img = new Image();
            img.onload = function () {
                on_load_one(true);
            };
            img.onerror = function () {
                on_load_one(false);
            };
            img.src = url;
        } else if (type == 'audio') {
            var audio = new Audio(url);
            on_load_one(true);
            audio.load(); // todo(aug) change to onload event
        }
    };
    var on_load_one = function (result) {
        ++loaded_count;
        if (result) {
            loaded_success++;
        } else {
            loaded_failed++;
        }
        if ($loading_text && $.isFunction($loading_text)) {
            $loading_text(loaded_success, loaded_failed, total);
        }
    };
    var check = function () {
        //定时检查加载
        if (0 >= check_time) {
            if (loaded_count / total > .8) {
                complete();
            } else {
                alert('加载图片失败，请返回刷新尝试!');
            }
        } else {
            check_time -= .5;
            if (loaded_count == total) {
                complete();
            } else {
                var _this = this;
                setTimeout(function () {
                    check();
                }, 500);
            }
        }
    };
    var complete = function () {
        if (on_complete) {
            on_complete(loaded_success, loaded_failed, total);
        }
    };
    return function (resource_list, callback, $loading_text) {
        init(resource_list, callback, $loading_text);
        load();
        check();
    };
}();