<?php
namespace User\Controller;

use Zhida\ExcelExporter;

class ReportController extends BaseUserController
{
    const APP_NAME = "dfzc-znts";

    public function index()
    {
        $this->mobile();
        return;
    }
    public function mobile()
    {
        $channel = $_GET['channel'];
        if (!$channel) {
            $channel = '__all__';
        }

        $url = "http://api2.izhida.cn/tongjiV2/report?app_stat_key=3Hak8h55DnysDSH5&app_stat_secret=zDWAssidakFaFyjH";
        $content = file_get_contents($url);
        $data = json_decode($content, true);
        $data_list = $data['data'];

        $event_meta_list = $this->get_event_meta();
        $count_1=M('Prize')->where(array(
            'type'=>1,
            'is_get'=>0
        ))->count();
        $count_2=M('Prize')->where(array(
            'type'=>2,
            'is_get'=>0
        ))->count();

        $count_3=M('Prize')->where(array(
            'type'=>3,
            'is_get'=>0
        ))->count();
        $count_4=M('Prize')->where(array(
            'type'=>4,
            'is_get'=>0
        ))->count();
        $this->assign('count_1',$count_1);
        $this->assign('count_2',$count_2);
        $this->assign('count_3',$count_3);
        $this->assign('count_4',$count_4);
        $this->assign('event_meta_list', $event_meta_list);

        $this->assign('data_list', $data_list[$channel]);

        $this->display("Report_index");
    }
    public function export_pvuv()
    {
        $channel = $_GET['channel'];
        if (!$channel) {
            $channel = '__all__';
        }
        $url = "http://api2.izhida.cn/tongjiV2/report?app_stat_key=3Hak8h55DnysDSH5&app_stat_secret=zDWAssidakFaFyjH";
        $content = file_get_contents($url);
        $data = json_decode($content, true);
        $data_list = $data['data'][$channel];
        $default_0 = function ($v) {
            if (isset($v)) {
                return $v;
            }
            return 0;
        };
        $columns = array(
            array('日期', 'date'),
            array('UV', 'index_uv', $default_0),
            array('PV', 'index_pv', $default_0),
            array('分享给朋友或微信群人数', 'share_uv_friend', $default_0),
            array('分享给朋友或微信群次数', 'share_pv_friend', $default_0),
            array('分享朋友圈人数', 'share_uv_timeline', $default_0),
            array('分享朋友圈次数', 'share_pv_timeline', $default_0),
            array('来自朋友圈人数', 'from_uv_timeline', $default_0),
            array('来自朋友圈次数', 'from_pv_timeline', $default_0),
            array('来自微信群人数', 'from_uv_groupmessage', $default_0),
            array('来自微信群次数', 'from_pv_groupmessage', $default_0),
            array('来自好友人数', 'from_uv_singlemessage', $default_0),
            array('来自好友次数', 'from_pv_singlemessage', $default_0),

        );
        $file_name = 'pvuv_' . date('Y-m-d_H:i:s');
        ExcelExporter::export($file_name, $columns, $data_list, 'pvuv');

    }
    public function export_photo()
    {
        $list = M('User')->where(array(
            "photo"=>array('NEQ','NULL')
        ))->select();
        $default_0 = function ($v) {
            if (isset($v)) {
                return $v;
            }
            return 0;
        };

        $columns = array(
            array('id', 'id', $default_0),
            array('微信名字', 'nickname', $default_0),
            array('头像', 'headimgurl', $default_0),
            array('图片', 'photo', $default_0),

        );
        $file_name = 'prize_' . date('Y-m-d_H:i:s');
        ExcelExporter::export($file_name, $columns, $list, 'prize');

    }
    public function export_prize()
    {
        $list = M('Prize')->where(array(
            "user_id"=>array('NEQ','0')
        ))->select();
        $default_0 = function ($v) {
            if (isset($v)) {
                return $v;
            }
            return 0;
        };

        $columns = array(
            array('id', 'id', $default_0),
            array('奖品名字', 'content', $default_0),
            array('微信ID', 'user_id', $default_0),
            array('名字', 'name', $default_0),
            array('手机号码', 'tel', $default_0),
            array('地区', 'address', $default_0),
//            array('填写信息时间', 'reward_time',  function($v){
//                return date('Y年m月d日-H:i:s', $v);
//            }),
            array('中奖时间', 'take_time',  function($v){
                return date('Y年m月d日-H:i:s', $v);
            }),

        );
        $file_name = 'prize_' . date('Y-m-d_H:i:s');
        ExcelExporter::export($file_name, $columns, $list, 'prize');

    }
    private function get_event_meta()
    {
        $event_meta_list = array(
            array("screen_name" => "UV", "item_name" => "index_uv", "type" => 'uv',),
            array("screen_name" => "PV", "item_name" => "index_pv", "type" => 'pv',),
            array("screen_name" => "分享给朋友或微信群人数", "item_name" => "share_uv_friend", "type" => 'uv',),
            array("screen_name" => "分享给朋友或微信群次数", "item_name" => "share_pv_friend", "type" => 'pv',),
            array("screen_name" => "分享朋友圈人数", "item_name" => "share_uv_timeline", "type" => 'uv',),
            array("screen_name" => "分享朋友圈次数", "item_name" => "share_pv_timeline", "type" => 'pv',),
            array("screen_name" => "来自朋友圈人数", "item_name" => "from_uv_timeline", "type" => 'uv',),
            array("screen_name" => "来自朋友圈次数", "item_name" => "from_pv_timeline", "type" => 'pv',),
            array("screen_name" => "来自微信群人数", "item_name" => "from_uv_groupmessage", "type" => 'uv',),
            array("screen_name" => "来自微信群次数", "item_name" => "from_pv_groupmessage", "type" => 'pv',),

            array("screen_name" => "来自好友人数", "item_name" => "from_uv_singlemessage", "type" => 'uv',),
            array("screen_name" => "来自好友次数", "item_name" => "from_pv_singlemessage", "type" => 'pv',),

        );


        foreach ($event_meta_list as &$item) {
            if (empty($item['item_name'])) {
                if ($item['condition']['category'] == "system") {
                    $item['item_name'] = $item['condition']["event_action"];
                } else {
                    $arr = array();
                    if (!empty($item['event_value'])) {
                        $arr[] = $item['category'];
                        $arr[] = $item['event_action'];
                        $arr[] = $item['event_name'];
                        $arr[] = $item['event_value'];
                    } elseif (!empty($item['event_name'])) {
                        $arr[] = $item['category'];
                        $arr[] = $item['event_action'];
                        $arr[] = $item['event_name'];
                    } elseif (!empty($item['event_action'])) {
                        $arr[] = $item['category'];
                        $arr[] = $item['event_action'];
                    } elseif (!empty($item['category'])) {
                        $arr[] = $item['category'];
                    } else {
                        continue;
                    }
                    $item_name = join('$', $arr);
                    if ($item['type'] == 'pv') {
                        $item_name .= '$__pv__';
                    } else {
                        $item_name .= '$__uv__';
                    }
                    $item['item_name'] = $item_name;
                }
            }
        }
        unset($item);
        return $event_meta_list;
    }


}