function preloadimages(obj, complete_cb, progress_cb) {
    var loaded = 0;
    var toload = 0;
    var images = obj instanceof Array ? [] : {};
    toload = obj.length;
    for (var i = 0; i < obj.length; i++) {
        images[i] = new Image();
        images[i].src = obj[i];
        // console.log(obj[i]);
        images[i].onload = load;
        images[i].setAttribute('crossOrigin', 'anonymous');
        images[i].onerror = load;
        images[i].onabort = load;
    }
    if (obj.length == 0) {
        complete_cb(images);
    }

    function load() {
        ++loaded;
        if (progress_cb) {
            progress_cb(loaded / toload);
        }
        if (loaded >= toload) {
            complete_cb(images);
        }
    }
}

var picUrl = window.base_resource_url + '/images/';

var preloadImageList = [
    // picUrl + 'share.png',
];
if ($('div').length > 0) {
    $.each($('div'), function (index, val) {
        var img = $(val).css('background-image').replace(/^url\((['"]?)(.*)\1\)$/, '$2');
        img = $.trim(img);
        if (img && img.match(/[^/]+(jpg|png|gif)$/)) {
            preloadImageList.push(img);
        }
    });
}


preloadimages(preloadImageList, function () {
    $('.page1').show();
}, function (progress) {

});

// $('input[name=tel]').attr('type','tel');
// $('input[name=tel]').attr('maxlength',11);

let flag = [
    '升职加薪',
    '早日暴富',
    '拿到一个新项目',
    '考过CFA',
    '迎战CPA',
    '读10本金融类书籍',
    '提升工作核心技能',
    '拿下自己的Dream car',
    '买一套小房子',
    '存款超过6位数',
    '回家继承家业',
    '结婚，靠份子钱增收',
    '拥有苹果全家桶',
    '坚持基金定投',
    '坚持记账',
    'get一项理财技能',
    '为孩子做教育基金定投',

    '好好存钱，认真把养老问题提上日程',
    '投资收益超主业，躺着赚钱',
    '靠理财收益，实现水果自由',
    '好好理财，买全李佳琪推荐口红',
    '理财收益多一点，猫粮争取升一级',
    '用理财收益，来场说走就走的旅行',
    '多赚钱，去看一看世界和远方',
];

let flagStack = [];
let chooseNum = 0;
let oldRandFlag = [];

let flagTemplate = $('.flag-frame').find('.flag-block').clone();
$('.flag-frame').html('').addClass('clearfix');
$('input[name=customize-flag]').attr('placeholder', '也能在这里写你的flag哦');

$(document).ready(function () {
    $("input").on("blur", function () {
        window.scroll(0, 0); //失焦后强制让页面归位
    });
    // $('.logo').css('top',getTranslateDistance(15));
    //
    $('.page1 .btn-next').on('click', showFlagPage);
    //换一换按钮点击
    $('.flag-page .btn-change').on('click', randomFlag);
    //选择flag
    $(document).on('click', '.flag-page .flag-block', addFlag);
    //自定义flag
    $('.flag-page .btn-submit-flag').on('click', addCustomizeFlag);
});

function addCustomizeFlag() {
    let text = $('input[name=customize-flag]').val();
    if (text.match(/^\s*$/)) {
        $('#notification_area').remove();
        my_notify('请填写flag');
        return false;
    }
    flagStack.push(text);
    $('.flag-page .choose-num').text((chooseNum++) + 1);
}

function addFlag() {
    let text = $(this).find('.flag-text').text();
    flagStack.push(text);
    $('.flag-page .choose-num').text((chooseNum++) + 1);
}

function showFlagPage() {
    $('.page1').hide();
    $('.flag-page').show();
    $('.flag-page .choose-num').text(chooseNum);
    let flagArr = randomFlag();
    for (let i = 0; i < flagArr.length; i++) {
        fadeInTextUp(flag[flagArr[i]], 1000, '.flag' + (i + 1))
    }

}

function randomFlag() {
    $('.flag-frame').html('');
    let flagArr = randomFlagArr(6);
    for (let i = 0; i < flagArr.length; i++) {
        createItem(flag[flagArr[i]], i + 1);
    }
    return flagArr;
}

function randomFlagArr(length) {
    let arr = Array(length);
    for (let i = 0; i < arr.length; i++) {
        arr[i] = getRand(arr);
    }
    arr.sort(function (a, b) {
        return a - b;
    });
    oldRandFlag = arr;

    return arr;
}

function getRand(arr) {
    let i = RandomNumBoth(0, flag.length - 1);
    if (arr.indexOf(i) == -1 && oldRandFlag.indexOf(i) == -1) {
        return i;
    } else {
        return getRand(arr);
    }
}

function createItem(flag, no) {
    let item = flagTemplate.clone();
    item.find('.flag-no').text(no);
    item.find('.flag-text').text(flag).addClass('flag' + no);
    $('.flag-frame').append(item);
}

function fadeInTextUp(text, fadeTime, divName) {
    //清空div
    $(divName).text('');
    //分割待处理的数组
    let textArr = text.split('');
    for (let i = 0; i < textArr.length; i++) {
        //遍历数组添加到目标div中
        $(divName).append($('<div class="fly' + i + '">' + textArr[i] + '</div>'));
        //为每个文字设置初始位置并将opacity设置为0，执行fadeTime制定的fadein
        $(divName + ' .fly' + i).css('transform', 'translateY(' + RandomNumBoth(22, 25) + 'rem)').fadeOut(0).fadeIn(fadeTime);
    }
    setTimeout(function () {
        //待动画执行完毕后删除动画div，将文字合并
        $(divName + ' .flag-text').text(text);
    }, 3000);
}

function getTranslateDistance(cardinal = 0) {
    var wrapInnerTransform = $('.wrap-inner').css('transform');
    var wrapInnertop = parseFloat($('.wrap-inner').css('top'));
    wrapInnerTransform = wrapInnerTransform.match(/^matrix\(1,\s0,\s0,\s1,\s0,\s\-?(\d+)/);
    wrapInnerTransform = parseFloat(wrapInnerTransform[1]);
    var wrapInnerjl = Math.abs(wrapInnertop - wrapInnerTransform);
    return wrapInnerjl + cardinal + 'px';
}

//获取随机数方法
//min 最小值
//max 最大值
function RandomNumBoth(Min, Max) {
    var Range = Max - Min;
    var Rand = Math.random();
    var num = Min + Math.round(Rand * Range); //四舍五入
    return num;
}