{:extends file="groupuser_layout.tpl"}
{:block name="header_css" append}
    <link rel="stylesheet" href="/Public/static/admin/lib/DataTables-1.10.12/media/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet"
          href="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/css/buttons.bootstrap4.css">
    <link rel="stylesheet"
          href="/Public/static/admin/lib/DataTables-1.10.12/extensions/Select/css/select.dataTables.min.css">
    <link rel="stylesheet"
          href="/Public/static/admin/lib/DataTables-1.10.12/extensions/RowReorder/css/rowReorder.dataTables.min.css">
    <style>

    </style>
{:/block}
{:block name="content_title"}
{:/block}
{:block name="content_breadcrumb"}
    首页
{:/block}
{:block name="content_body"}
    <div class="panel panel-default">
        <div class="panel-body">
            <div class="table-responsive">
                <table class="table table-condensed" id="users_table">
                    <thead>
                    <tr>
                        <th class="text-left col-sm-1">id</th>
                        <th class="text-left col-sm-2">图片</th>
                        <th class="text-left col-sm-1">描述</th>
                        <th class="text-left col-sm-1">点赞数</th>
                        <th class="text-left col-sm-1">上传时间</th>
                        <th class="text-right col-sm-2">操作</th>
                    </tr>
                    </thead>
                    <tbody class="text-left">
                    {:foreach $list as $item}
                        <tr id="{:$item.id}">
                            <td>{:$item.id}</td>
                            <td class="pic"><img  style="max-width: 300px;" src="{:$item.pic_url}"></td>
                            <td class="title">{:$item.intro}</td>
                            <td class="single_intro">{:$item.like_count}</td>
                            <td class="update_time">{:$item.update_time|date_format:'%Y-%m-%d %H:%M:%S'}</td>
                            <td class="text-right">
                                <button class="btn btn-primary btn-sm go-button">通过</button> |
                                <button class="btn btn-danger btn-sm delete-button">否决</button>
                            </td>
                        </tr>
                    {:/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="modal fade" id="confirmModel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title">警告</h4>
                </div>
                <div class="modal-body">
                    <p>确定要删除吗?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    <button type="button" class="btn btn-primary" id="confirm_btn_certain">确定</button>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

{:/block}
{:block name="body_js" append}
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/media/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/media/js/dataTables.bootstrap4.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.bootstrap4.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Select/js/dataTables.select.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.print.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/RowReorder/js/dataTables.rowReorder.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/js/validator.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/plupload-2.1.9/js/plupload.full.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/qiniu/dist/qiniu.min.js"></script>
    <script src="https://cdn.bootcss.com/json2/20150503/json2.min.js"></script>
    <script>
        $(document).ready(function () {
            var lesson_id = {:$lesson.id|default:0};
            var table = $('#users_table').DataTable({
                "bLengthChange": false,
                paging: false,
                'bSort': false,
//                columnDefs: [
//                    {orderable: false, targets: '_all'},
//                ],
//                select: {
//                    style: 'multi',
//                    selector: 'td:nth-child(1)'
//                },
                'language': {
                    "sProcessing": "处理中...",
                    "sLengthMenu": "显示 _MENU_ 项结果",
                    "sZeroRecords": "没有匹配结果",
                    "sInfo": "显示第 _START_ 至 _END_ 项结果，共 _TOTAL_ 项",
                    "sInfoEmpty": "显示第 0 至 0 项结果，共 0 项",
                    "sInfoFiltered": "(由 _MAX_ 项结果过滤)",
                    "sInfoPostFix": "",
                    "sSearch": "搜索:",
                    "sUrl": "",
                    "sEmptyTable": "表中数据为空",
                    "sLoadingRecords": "载入中...",
                    "sInfoThousands": ",",
                    "oPaginate": {
                        "sFirst": "首页",
                        "sPrevious": "上页",
                        "sNext": "下页",
                        "sLast": "末页"
                    },
                    "oAria": {
                        "sSortAscending": ": 以升序排列此列",
                        "sSortDescending": ": 以降序排列此列"
                    }
                }
            });
            table.buttons().container().appendTo('#users_table_wrapper .col-md-6:eq(0)');

            $('#users_table tbody').on('click', '.edit-button', function () {
                var id = table.row($(this).parents('tr')).id();
                var tr = $(this).parents('tr');
                var info = $(this).parents('tr').data('info');
                var type = $(this).parents('tr').data('type');
                var rank = $(this).parents('tr').data('rank');
                console.log(info);
                var modal = $('#productModal');
                modal.find('#id').val(id);
                modal.find("#type").val(type);
                modal.find("input[name='rank']").val(rank);
                modal.find("input[name='title']").val(tr.find('.title').text());
                modal.find("input[name='pic']").val(tr.find('.pic img')[0].src);
                modal.find("input[name='single_intro']").val(tr.find('.single_intro').text());
                modal.find("textarea[name='complete_intro']").val(tr.find('.complete_intro').text());
                var banners = $(this).parents('tr').data('banners').split(',');
                for (var i = 0; i <  banners.length; i++) {
                    modal.find("#banner" +i ).val(banners[i]);
                }

                modal.modal();
            });
            $('#productModal').on('hidden.bs.modal', function (e) {
                console.log('guang');
                var modal = $('#productModal');
                modal.find('#id').val(0);
                modal.find("#type").val(1);
                modal.find("input[name='title']").val('');
                modal.find("input[name='pic']").val('');
                modal.find("input[name='single_intro']").val('');
                modal.find("textarea[name='complete_intro']").val('');
                for (var i = 0; i <  5; i++) {
                    modal.find("#banner" +i ).val('');
                }
            })
//            var rows = null;
//            $('#users_table tbody').on('click', '.delete-button', function () {
//                $('#confirmModel').modal();
//                rows = table.row($(this).parents('tr'));
//            });

            $('#users_table tbody').on('click', '.delete-button', function () {
                var id = table.row($(this).parents('tr')).id();

                var _this = this;
                $.post('/Admin/Product/productDelete', {
                    id: id
                }, function (resp) {
                    console.log(resp);
                    table.row($(_this).parents('tr')).remove().draw( false );
                });
            });


            $('#users_table tbody').on('click', '.go-button', function () {
                var id = table.row($(this).parents('tr')).id();
                var _this = this;
                $.post('/Admin/Product/productCertain', {
                    id: id
                }, function (resp) {
                    console.log(resp);
                    table.row($(_this).parents('tr')).remove().draw( false );
                });
            });


            $('#users_table tbody').on('click', '.add-button', function () {
                var id = table.row($(this).parents('tr')).id();
                console.log(id);
                var modal = $('#subjectModel');

                modal.find('.chapter_id').val(id);
                modal.find('.lesson_id').val(lesson_id);
                modal.modal();
            });

            $('#confirm_btn_certain').on('click', function () {
                var data = {
                    list: rows.ids().toArray()
                };
                $.post('/Admin/Product/productDelete', data, function (resp) {
                    console.log(resp);
                    $('#confirmModel').modal('hide');
                    rows.remove().draw(false);
                });
            });

            $('#boxAll').on('click', function () {
                if ($('#checkboxAll').get(0).checked == true) {
                    table.rows().select();
                } else {
                    table.rows().deselect();
                }
            });

            table.on('row-reordered', function(e, details, edit){
                setTimeout(function () {
                    var ids = table.rows().ids();
                    var data = {
                        ranks: ids.toArray().toString(),
                        lesson_id: lesson_id
                    };
                    $.post('/Admin/Lesson/setRanks', data, function (resp) {
                        console.log(resp);
                    });
                },300);
            });


            var uploader = {};
            $.each($('.qiniu'), function (index, val) {
                var oldText;
                uploader[index] = Qiniu.uploader({
                    untimes: 'html5,flash,html4',
                    browse_button: val,
                    get_new_uptoken: false,
                    domain: 'https://tofax-salesman-cdn.izhida.cn/',
                    uptoken_url: '{:U('/Admin/Product/getToken')}',
                    container: $(val).parent().get(0),
                    max_file_size: '300mb',
                    flash_swf_url: 'https://cdn.bootcss.com/plupload/2.1.9/Moxie.swf',
                    max_retries: 3,
                    unique_names: true,
                    dragdrop: false,
                    multi_selection: false,
                    drop_element: $(val).parent().get(0),
                    chunk_size: '4mb',
                    auto_start: true,
                    filters: {
                        max_file_size: '300mb',
                        prevent_duplicates: true,
                        mime_types: [
                            {title: "Image files", extensions: "jpg,gif,png"}, // 限定jpg,gif,png后缀上传
                        ]
                    },
                    init: {
                        'UploadProgress': function (up, file) {
                            percentage = parseInt(file.percent, 10);
                            if (file.status !== plupload.DONE && percentage === 100) {
                                percentage = 99;
                            }
                            var formatSpeed = plupload.formatSize(file.speed).toUpperCase();
                            $(val).addClass('disabled').text(percentage + '%');
                            // $('.progress .progress-bar').attr('aria-valuenow', percentage).css('width', percentage + '%');
                            // $('.progress .progress-bar').text( percentage + '% Complete Speed:'+formatSpeed + '/s' );
                        },
                        'BeforeUpload': function (up, file) {
                            if ($(val).hasClass('disabled')) {
                                return false;
                            }
                            oldText = $(val).text();

                            // $('.progress .progress-bar').attr('aria-valuenow', 0).css('width', '0');
                            // $('.progress .progress-bar').text('');
                            // $('.progress').show();
                        },
                        'FileUploaded': function (up, file, info) {
                            var res = $.parseJSON(info);
                            var domain = up.getOption('domain');
                            url = domain + encodeURI(res.key);
                            $(val).closest('.input-group').find('input[readonly]').val(url);
                            //$('#videos-url').val(url);
                        },
                        'Error': function (up, err, errTip) {
                            alert(errTip);
                        },
                        'UploadComplete': function () {
                            setTimeout(function () {
                                $(val).removeClass('disabled').text(oldText);
                            }, 100);
                        }
                    }
                });
            });
        });
    </script>
{:/block}